# Define options
set val(chan) Channel/WirelessChannel ;# channel type
set val(prop) Propagation/TwoRayGround ;# radio-propagation model
set val(netif) Phy/WirelessPhy ;# network interface type
set val(mac) Mac/802_11 ;# MAC type
set val(ifq) Queue/DropTail/PriQueue ;# interface queue type
set val(ll) LL ;# link layer type
set val(ant) Antenna/OmniAntenna ;# antenna model
set val(ifqlen) 50 ;# max packet in ifq
set val(nn) 30 ;# number of mobilenodes
set val(rp) AODV ;# routing protocol
set val(x) 1000 ;# X dimension of topography
set val(y) 1000 ;# Y dimension of topography
set val(stop) 150 ;# time of simulation end

set ns [new Simulator]
set tracefd [open thesis-vegas.tr w]
set namtrace [open thesis-vegas.nam w]
#set windowVsTime2 [open win.tr w] 
$ns trace-all $tracefd
$ns namtrace-all-wireless $namtrace $val(x) $val(y)

# set up topography object
set topo [new Topography]

$topo load_flatgrid $val(x) $val(y)

create-god $val(nn)

# configure the nodes
$ns node-config -adhocRouting $val(rp) \
-llType $val(ll) \
-macType $val(mac) \
-ifqType $val(ifq) \
-ifqLen $val(ifqlen) \
-antType $val(ant) \
-propType $val(prop) \
-phyType $val(netif) \
-channelType $val(chan) \
-topoInstance $topo \
-agentTrace ON \
-routerTrace ON \
-macTrace ON \
-movementTrace ON

# Energy model for every node
#Energy=Power*time
#Jule is unit of initialEnergy and rest of Energy is unit is watt
#$ns node-config  -energyModel EnergyModel \
#-initialEnergy 20 \
#-txPower 0.744 \
#-rxPower 0.0648 \
#-idlePower 0.05 \
#-sensePower 0.0175 

#source 'thesis1.tcl';

for {set i 0} {$i < $val(nn) } { incr i } {
set n($i) [$ns node]
}

$n(0) set initialEnergy 5
$n(1) set initialEnergy 25
$n(2) set initialEnergy 15

# Provide initial location of mobilenodes

$n(0) set X_ 105.0
$n(0) set Y_ 206.0
$n(0) set Z_ 0.0

$n(1) set X_ 805.0
$n(1) set Y_ 742.0
$n(1) set Z_ 0.0

$n(2) set X_ 515.0
$n(2) set Y_ 606.0
$n(2) set Z_ 0.0

$n(3) set X_ 405.0
$n(3) set Y_ 342.0
$n(3) set Z_ 0.0

$n(4) set X_ 675.0
$n(4) set Y_ 156.0
$n(4) set Z_ 0.0

$n(5) set X_ 905.0
$n(5) set Y_ 549.0
$n(5) set Z_ 0.0

$n(6) set X_ 675.0
$n(6) set Y_ 336.0
$n(6) set Z_ 0.0

$n(7) set X_ 555.0
$n(7) set Y_ 762.0
$n(7) set Z_ 0.0

$n(8) set X_ 258.0
$n(8) set Y_ 646.0
$n(8) set Z_ 0.0

$n(9) set X_ 645.0
$n(9) set Y_ 522.0
$n(9) set Z_ 0.0

$n(10) set X_ 265.0
$n(10) set Y_ 376.0
$n(10) set Z_ 0.0

$n(11) set X_ 495.0
$n(11) set Y_ 502.0
$n(11) set Z_ 0.0

$n(12) set X_ 75.0
$n(12) set Y_ 426.0
$n(12) set Z_ 0.0

$n(13) set X_ 145.0
$n(13) set Y_ 119.0
$n(13) set Z_ 0.0

$n(14) set X_ 85.0
$n(14) set Y_ 702.0
$n(14) set Z_ 0.0

$n(15) set X_ 340.0
$n(15) set Y_ 36.0
$n(15) set Z_ 0.0

$n(16) set X_ 758.0
$n(16) set Y_ 602.0
$n(16) set Z_ 0.0

$n(17) set X_ 435.0
$n(17) set Y_ 186.0
$n(17) set Z_ 0.0

$n(18) set X_ 5.0
$n(18) set Y_ 2.0
$n(18) set Z_ 0.0

$n(19) set X_ 515.0
$n(19) set Y_ 366.0
$n(19) set Z_ 0.0

$n(20) set X_ 420.0
$n(20) set Y_ 115.0
$n(20) set Z_ 0.0

$n(21) set X_ 190.0
$n(21) set Y_ 80.0
$n(21) set Z_ 0.0

$n(22) set X_ 665.0
$n(22) set Y_ 110.0
$n(22) set Z_ 0.0

$n(23) set X_ 745.0
$n(23) set Y_ 300.0
$n(23) set Z_ 0.0

$n(24) set X_ 830.0
$n(24) set Y_ 625.0
$n(24) set Z_ 0.0

$n(25) set X_ 950.0
$n(25) set Y_ 800.0
$n(25) set Z_ 0.0

$n(26) set X_ 740.0
$n(26) set Y_ 495.0
$n(26) set Z_ 0.0

$n(27) set X_ 695.0
$n(27) set Y_ 240.0
$n(27) set Z_ 0.0

$n(28) set X_ 810.0
$n(28) set Y_ 560.0
$n(28) set Z_ 0.0

$n(29) set X_ 1000.0
$n(29) set Y_ 870.0
$n(29) set Z_ 0.0

# Establish TCP connection
#
set tcp(0) [new Agent/TCP/Vegas]
set sink(0) [new Agent/TCPSink]
$tcp(0) set window 500
$tcp(0) set packetSize 1024
$ns attach-agent $n(0) $tcp(0)
$ns attach-agent $n(20) $sink(0)
$ns connect $tcp(0) $sink(0)
set ftp(0) [new Application/FTP]
$ftp(0) attach-agent $tcp(0)
$ns at 1.05644 "$ftp(0) start"

set tcp(1) [new Agent/TCP/Vegas]
set sink(1) [new Agent/TCPSink]
$tcp(1) set window 500
$tcp(1) set packetSize 1024
$ns attach-agent $n(1) $tcp(1)
$ns attach-agent $n(21) $sink(1)
$ns connect $tcp(1) $sink(1)
set ftp(1) [new Application/FTP]
$ftp(1) attach-agent $tcp(1)
$ns at 167.94106 "$ftp(1) start"

set tcp(2) [new Agent/TCP/Vegas]
set sink(2) [new Agent/TCPSink]
$tcp(2) set window 500
$tcp(2) set packetSize 1024
$ns attach-agent $n(2) $tcp(2)
$ns attach-agent $n(22) $sink(2)
$ns connect $tcp(2) $sink(2)
set ftp(2) [new Application/FTP]
$ftp(2) attach-agent $tcp(2)
$ns at 80.84141 "$ftp(2) start"

set tcp(3) [new Agent/TCP/Vegas]
set sink(3) [new Agent/TCPSink]
$tcp(3) set window 500
$tcp(3) set packetSize 1024
$ns attach-agent $n(3) $tcp(3)
$ns attach-agent $n(23) $sink(3)
$ns connect $tcp(3) $sink(3)
set ftp(3) [new Application/FTP]
$ftp(3) attach-agent $tcp(3)
$ns at 59.22420 "$ftp(3) start"

set tcp(4) [new Agent/TCP/Vegas]
set sink(4) [new Agent/TCPSink]
$tcp(4) set window 500
$tcp(4) set packetSize 1024
$ns attach-agent $n(4) $tcp(4)
$ns attach-agent $n(24) $sink(4)
$ns connect $tcp(4) $sink(4)
set ftp(4) [new Application/FTP]
$ftp(4) attach-agent $tcp(4)
$ns at 147.20770 "$ftp(4) start"

set tcp(5) [new Agent/TCP/Vegas]
set sink(5) [new Agent/TCPSink]
$tcp(5) set window 500
$tcp(5) set packetSize 1024
$ns attach-agent $n(5) $tcp(5)
$ns attach-agent $n(25) $sink(5)
$ns connect $tcp(5) $sink(5)
set ftp(5) [new Application/FTP]
$ftp(5) attach-agent $tcp(5)
$ns at 150.62913 "$ftp(5) start"

set tcp(6) [new Agent/TCP/Vegas]
set sink(6) [new Agent/TCPSink]
$tcp(6) set window 500
$tcp(6) set packetSize 1024
$ns attach-agent $n(6) $tcp(6)
$ns attach-agent $n(26) $sink(6)
$ns connect $tcp(6) $sink(6)
set ftp(6) [new Application/FTP]
$ftp(6) attach-agent $tcp(6)
$ns at 136.71515 "$ftp(6) start"

set tcp(7) [new Agent/TCP/Vegas]
set sink(7) [new Agent/TCPSink]
$tcp(7) set window 500
$tcp(7) set packetSize 1024
$ns attach-agent $n(7) $tcp(7)
$ns attach-agent $n(27) $sink(7)
$ns connect $tcp(7) $sink(7)
set ftp(7) [new Application/FTP]
$ftp(7) attach-agent $tcp(7)
$ns at 100.17584 "$ftp(7) start"

set tcp(8) [new Agent/TCP/Vegas]
set sink(8) [new Agent/TCPSink]
$tcp(8) set window 500
$tcp(8) set packetSize 1024
$ns attach-agent $n(8) $tcp(8)
$ns attach-agent $n(28) $sink(8)
$ns connect $tcp(8) $sink(8)
set ftp(8) [new Application/FTP]
$ftp(8) attach-agent $tcp(8)
$ns at 48.54536 "$ftp(8) start"

set tcp(9) [new Agent/TCP/Vegas]
set sink(9) [new Agent/TCPSink]
$tcp(9) set window 500
$tcp(9) set packetSize 1024
$ns attach-agent $n(9) $tcp(9)
$ns attach-agent $n(29) $sink(9)
$ns connect $tcp(9) $sink(9)
set ftp(9) [new Application/FTP]
$ftp(9) attach-agent $tcp(9)
$ns at 14.44060 "$ftp(9) start"


#defining heads
$ns at 0.0 "$n(0) label CH"
$ns at 0.0 "$n(1) label Source"
$ns at 0.0 "$n(13) label Destination"
#$ns at 0.0 "$n(2) label N2"

#new location after move
$ns at 0.0 "$n(0) setdest 130.0 208.0 5.0"
$ns at 0.0 "$n(1) setdest 485.0 128.0 5.0"
$ns at 1.0 "$n(2) setdest 615.0 340.0 5.0"
$ns at 1.0 "$n(3) setdest 680.0 458.0 5.0"
$ns at 3.0 "$n(4) setdest 580.0 368.0 5.0"
$ns at 3.0 "$n(5) setdest 785.0 228.0 5.0"
$ns at 2.0 "$n(6) setdest 750.0 638.0 5.0"
$ns at 1.0 "$n(7) setdest 185.0 120.0 5.0"
$ns at 0.0 "$n(8) setdest 335.0 700.0 5.0"
$ns at 2.0 "$n(9) setdest 425.0 590.0 5.0"
$ns at 2.0 "$n(10) setdest 105.0 620.0 5.0"
$ns at 0.0 "$n(11) setdest 565.0 420.0 5.0"
$ns at 1.0 "$n(12) setdest 700.0 20.0 5.0"
$ns at 1.0 "$n(13) setdest 115.0 85.0 5.0"
$ns at 1.0 "$n(14) setdest 195.0 185.0 5.0"
$ns at 1.0 "$n(15) setdest 387.0 590.0 5.0"
$ns at 2.0 "$n(16) setdest 165.0 620.0 5.0"
$ns at 0.0 "$n(17) setdest 765.0 320.0 5.0"
$ns at 1.0 "$n(18) setdest 109.0 20.0 5.0"
$ns at 1.0 "$n(19) setdest 175.0 185.0 5.0"
$ns at 2.0 "$n(20) setdest 405.0 820.0 5.0"
$ns at 0.0 "$n(21) setdest 665.0 680.0 5.0"
$ns at 1.0 "$n(22) setdest 750.0 380.0 5.0"
$ns at 1.0 "$n(23) setdest 215.0 135.0 5.0"
$ns at 1.0 "$n(24) setdest 795.0 285.0 5.0"
$ns at 1.0 "$n(25) setdest 687.0 690.0 5.0"
$ns at 2.0 "$n(26) setdest 565.0 420.0 5.0"
$ns at 0.0 "$n(27) setdest 465.0 220.0 5.0"
$ns at 1.0 "$n(28) setdest 390.0 120.0 5.0"
$ns at 1.0 "$n(29) setdest 475.0 215.0 5.0"

##################################################
## Obtain CWND from TCP agent
##################################################

proc plotWindow {tcpSource outfile} {
   global ns

   set now [$ns now]
   set cwnd [$tcpSource set cwnd_]

###Print TIME CWND   for  gnuplot to plot progressing on CWND   
   puts  $outfile  "$now $cwnd"

   $ns at [expr $now+0.1] "plotWindow $tcpSource  $outfile"
}

set outfile [open  "Win1"  w]
set outfile0 [open  "Win2"  w]
set outfile1 [open  "Win3"  w]
set outfile2 [open  "Win4"  w]
set outfile3 [open  "Win5"  w]
set outfile4 [open  "Win6"  w]
set outfile5 [open  "Win7"  w]
set outfile6 [open  "Win8"  w]
set outfile7 [open  "Win9"  w]
set outfile8 [open  "Win10"  w]


$ns  at  0.0  "plotWindow $tcp(0)  $outfile"
$ns  at  0.0  "plotWindow $tcp(1)  $outfile0"
$ns  at  0.0  "plotWindow $tcp(2)  $outfile1"
$ns  at  0.0  "plotWindow $tcp(3)  $outfile2"
$ns  at  0.0  "plotWindow $tcp(4)  $outfile3"
$ns  at  0.0  "plotWindow $tcp(5)  $outfile4"
$ns  at  0.0  "plotWindow $tcp(6)  $outfile5"
$ns  at  0.0  "plotWindow $tcp(7)  $outfile6"
$ns  at  0.0  "plotWindow $tcp(8)  $outfile7"
$ns  at  0.0  "plotWindow $tcp(9)  $outfile8"
#$ns  at  100.0  "plotWindow $tcp(10)  $outfile9"

# Define node initial position in nam
for {set i 0} {$i < $val(nn)} { incr i } {
# 40 defines the node size for nam
$ns initial_node_pos $n($i) 60
}

# Telling nodes when the simulation ends
for {set i 0} {$i < $val(nn) } { incr i } {
$ns at $val(stop) "$n($i) reset";
}
# ending nam and the simulation
$ns at $val(stop) "$ns nam-end-wireless $val(stop)"
$ns at $val(stop) "stop"
$ns at 150.01 "puts \"end simulation\" ; $ns halt"


proc stop {} {
	global ns tracefd namtrace
	$ns flush-trace
	close $tracefd
	close $namtrace
	#exec nam thesis-vegas.nam &

}
proc finish {} {
	#source shortest_path.tcl
	#mkMatrix
	 #exec xgraph thesis.tr -geometry 800x400 &
      #exec xgraph congestion.xg -geometry 800x400 &
	 	exit 0
}

$ns run
